#!/bin/sh

tmp_name=$1
[ -z "$tmp_name" ] && exit 1


folder="/var/app_data/tmp/dda_debuglog"
[ -e "${folder}" ] && rm -rf "${folder}"

folder="${folder}/${tmp_name}"
mkdir -p "${folder}" -m 777
sysinfo="${folder}/sysinfo"
mkdir -p "${sysinfo}" -m 777

# system-info
uname -a                > "${sysinfo}/kernel_version"
ps aux | grep -v "grep" > "${sysinfo}/process_info"
top -b -n 1             > "${sysinfo}/memory_info"


# related logs
filepath="${folder}/${tmp_name}.tar.gz"
tar -zc -f "${filepath}" \
    /etc/dtascfg.xml \
    /etc/issue \
    /etc/fstab \
    /opt/TrendMicro/DTAS/ManagementServer/hotfix_history.txt \
    /opt/TrendMicro/DTAS/ManagementServer/version.txt \
    /opt/TrendMicro/PI/platform/log/syslog.udp.log \
    /var/app_data/log/tomcat/ \
    /opt/TrendMicro/PI/platform/tomcat/core/webapps/ROOT/WEB-INF/au/lib/AU_Data/AU_Log/TmuDump.txt \
    /opt/TrendMicro/PI/platform/tomcat/zk/logs/ \
    /opt/TrendMicro/PI/platform/tomcat/solrmgr/logs/catalina* \
    /opt/TrendMicro/PI/platform/tomcat/storeT1S0/logs/ \
    /opt/TrendMicro/PI/platform/tomcat/storeT1S1/logs/ \
    /va/app_data/log/zg_middleware.log \
    /var/app_data/U-Sandbox/u-sandbox/usandbox_logs.zip \
    /var/app_data/DB_data/data/pg_log/ \
    -C "${folder}" "sysinfo/kernel_version" \
    -C "${folder}" "sysinfo/process_info" \
    -C "${folder}" "sysinfo/memory_info" \
    /var/app_data/log/messages* \
    /var/app_data/log/httpd/ \
    /var/app_data/log/atop/ \
    1>/dev/null 2>&1
    
ls "${filepath}" 1>/dev/null 2>&1
